/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks.complex;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import org.betterx.bclib.blocks.BaseBarkBlock;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.bclib.blocks.BaseStripableLogBlock;
import org.betterx.bclib.blocks.StripableBarkBlock;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.BlockEntry;
import org.betterx.bclib.complexmaterials.entry.ItemEntry;
import org.betterx.bclib.complexmaterials.entry.RecipeEntry;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.registry.BlockRegistry;
import org.betterx.bclib.registry.ItemRegistry;
import org.betterx.betternether.blocks.BNBarStool;
import org.betterx.betternether.blocks.BNNormalChair;
import org.betterx.betternether.blocks.BNTaburet;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.worlds.together.tag.v3.CommonItemTags;

public class NetherWoodenMaterial
extends WoodenComplexMaterial {
    protected static final String BLOCK_OPTIONAL_TRUNK = "trunk";
    protected static final String BLOCK_OPTIONAL_BRANCH = "branch";
    protected static final String BLOCK_OPTIONAL_ROOT = "roots";
    protected static final String BLOCK_OPTIONAL_SAPLING = "sapling";
    protected static final String BLOCK_OPTIONAL_SEED = "seed";
    protected static final String BLOCK_OPTIONAL_STEM = "stem";
    protected static final String BLOCK_OPTIONAL_ROOF = "roof";
    protected static final String BLOCK_OPTIONAL_ROOF_STAIRS = "roof_stairs";
    protected static final String BLOCK_OPTIONAL_ROOF_SLAB = "roof_slab";
    public static final String BLOCK_TABURET = "taburet";
    public static final String BLOCK_CHAIR = "chair";
    public static final String BLOCK_BAR_STOOL = "bar_stool";
    public static final String ITEM_BOAT = "boat";
    public static final String ITEM_CHEST_BOAT = "chest_boat";
    private BoatTypeOverride BOAT_TYPE;

    public NetherWoodenMaterial(String name, class_3620 woodColor, class_3620 planksColor) {
        super("betternether", name, "nether", woodColor, planksColor);
    }

    public ComplexMaterial init(BlockRegistry blocksRegistry, ItemRegistry itemsRegistry, PathConfig recipeConfig) {
        return super.init(blocksRegistry, itemsRegistry, recipeConfig);
    }

    public NetherWoodenMaterial init() {
        return (NetherWoodenMaterial)super.init(NetherBlocks.getBlockRegistry(), NetherItems.getItemRegistry(), Configs.RECIPE_CONFIG);
    }

    protected FabricBlockSettings getBlockSettings() {
        return FabricBlockSettings.copyOf((class_4970)class_2246.field_22127).mapColor(this.planksColor);
    }

    protected void _initBase(class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        super.initBase(blockSettings, itemSettings);
        class_6862 tagBlockLog = this.getBlockTag("logs");
        class_6862 tagItemLog = this.getItemTag("logs");
        this.replaceOrAddBlockEntry(new BlockEntry("stripped_log", (complexMaterial, settings) -> new BaseRotatedPillarBlock(settings)).setBlockTags(new class_6862[]{class_3481.field_15475, tagBlockLog}).setItemTags(new class_6862[]{class_3489.field_15539, tagItemLog}));
        this.replaceOrAddBlockEntry(new BlockEntry("stripped_bark", (complexMaterial, settings) -> new BaseBarkBlock(settings)).setBlockTags(new class_6862[]{class_3481.field_15475, tagBlockLog}).setItemTags(new class_6862[]{class_3489.field_15539, tagItemLog}));
        this.replaceOrAddBlockEntry(new BlockEntry("log", (complexMaterial, settings) -> new BaseStripableLogBlock(this.woodColor, this.getBlock("stripped_log"))).setBlockTags(new class_6862[]{class_3481.field_15475, tagBlockLog}).setItemTags(new class_6862[]{class_3489.field_15539, tagItemLog}));
        this.replaceOrAddBlockEntry(new BlockEntry("bark", (complexMaterial, settings) -> new StripableBarkBlock(this.woodColor, this.getBlock("stripped_bark"))).setBlockTags(new class_6862[]{class_3481.field_15475, tagBlockLog}).setItemTags(new class_6862[]{class_3489.field_15539, tagItemLog}));
    }

    protected void initBoats(class_1792.class_1793 itemSettings) {
        this.BOAT_TYPE = BoatTypeOverride.create((String)"betternether", (String)this.baseName, (class_2248)this.getPlanks());
        this.addItemEntry(new ItemEntry(ITEM_BOAT, (cmx, settings) -> this.BOAT_TYPE.createItem(false)));
        this.addItemEntry(new ItemEntry(ITEM_CHEST_BOAT, (cmx, settings) -> this.BOAT_TYPE.createItem(true)).setItemTags(new class_6862[]{class_3489.field_38080}));
    }

    protected void initDefault(class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        this._initBase(blockSettings, itemSettings);
        super.initStorage(blockSettings, itemSettings);
        this.initDecorations(blockSettings, itemSettings);
        this.addBlockEntry(new BlockEntry(BLOCK_TABURET, (complexMaterial, settings) -> new BNTaburet(this.getBlock("slab"))));
        this.addBlockEntry(new BlockEntry(BLOCK_CHAIR, (complexMaterial, settings) -> new BNNormalChair(this.getBlock("slab"))));
        this.addBlockEntry(new BlockEntry(BLOCK_BAR_STOOL, (complexMaterial, settings) -> new BNBarStool(this.getBlock("slab"))));
        this.initBoats(itemSettings);
    }

    public static void makeTaburetRecipe(PathConfig config, class_2960 id, class_2248 taburet, class_2248 planks) {
        BCLRecipeBuilder.crafting((class_2960)id, (class_1935)taburet).checkConfig(config).setShape(new String[]{"##", "II"}).addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup("nether_taburet").build();
    }

    public static void makeChairRecipe(PathConfig config, class_2960 id, class_2248 chair, class_2248 planks) {
        BCLRecipeBuilder.crafting((class_2960)id, (class_1935)chair).checkConfig(config).setShape(new String[]{"I ", "##", "II"}).addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup("nether_chair").build();
    }

    public static void makeBarStoolRecipe(PathConfig config, class_2960 id, class_2248 barStool, class_2248 planks) {
        BCLRecipeBuilder.crafting((class_2960)id, (class_1935)barStool).checkConfig(config).setShape(new String[]{"##", "II", "II"}).addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup("nether_bar_stool").build();
    }

    public static void makeBoatRecipe(PathConfig config, class_2960 id, class_2248 planks, class_1792 boat, class_1792 chestBoat, boolean hasChest) {
        if (hasChest) {
            BCLRecipeBuilder.crafting((class_2960)id, (class_1935)chestBoat).checkConfig(config).setList("C#").addMaterial('C', CommonItemTags.CHEST).addMaterial('#', new class_1935[]{boat}).setGroup("nether_chest_boat").build();
        } else {
            BCLRecipeBuilder.crafting((class_2960)id, (class_1935)boat).checkConfig(config).setShape(new String[]{"# #", "###"}).addMaterial('#', new class_1935[]{planks}).setGroup("nether_boat").build();
        }
    }

    protected void initDefaultFurniture() {
        class_2248 slab = this.getSlab();
        if (class_2378.field_11146.method_10221((Object)slab) != class_2378.field_11146.method_10137()) {
            this.addRecipeEntry(new RecipeEntry(BLOCK_TABURET, (material, config, id) -> NetherWoodenMaterial.makeTaburetRecipe(config, id, this.getBlock(BLOCK_TABURET), slab)));
            this.addRecipeEntry(new RecipeEntry(BLOCK_CHAIR, (material, config, id) -> NetherWoodenMaterial.makeChairRecipe(config, id, this.getBlock(BLOCK_CHAIR), slab)));
            this.addRecipeEntry(new RecipeEntry(BLOCK_BAR_STOOL, (material, config, id) -> NetherWoodenMaterial.makeBarStoolRecipe(config, id, this.getBlock(BLOCK_BAR_STOOL), slab)));
            this.addRecipeEntry(new RecipeEntry(ITEM_BOAT, (material, config, id) -> NetherWoodenMaterial.makeBoatRecipe(config, id, this.getPlanks(), this.getItem(ITEM_BOAT), this.getItem(ITEM_CHEST_BOAT), false)));
            this.addRecipeEntry(new RecipeEntry(ITEM_CHEST_BOAT, (material, config, id) -> NetherWoodenMaterial.makeBoatRecipe(config, id, this.getPlanks(), this.getItem(ITEM_BOAT), this.getItem(ITEM_CHEST_BOAT), true)));
        }
    }

    public void initDefaultRecipes() {
        super.initDefaultRecipes();
        this.initDefaultFurniture();
    }

    protected void initFlammable(FlammableBlockRegistry registry) {
    }

    public class_2248 getPlanks() {
        return this.getBlock("planks");
    }

    public class_2248 getSlab() {
        return this.getBlock("slab");
    }

    public class_2248 getLog() {
        return this.getBlock("log");
    }

    public class_2248 getBark() {
        return this.getBlock("bark");
    }

    public class_2248 getStrippedLog() {
        return this.getBlock("stripped_log");
    }

    public class_2248 getStrippedBark() {
        return this.getBlock("stripped_bark");
    }
}

